/* 
 * myhexdump-template.c 
 *
 * Виводить дамп заданого файлу в шістнадцятковому й текстовому форматі
 * (за зразком hexdump -C).
 * Ілюструє порядок застосування функцій open(), read(), write().
 *
 */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <libgen.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

enum { BUFSIZE = 16 };

int print_buffer(ssize_t count_all, char *buf, ssize_t count);
void supress_nonprint(char *buf, ssize_t count);


int main(int argc, char *argv[])
{
        int fd;
        /* Загальна кількість прочитаних із файлу байтів */
        ssize_t count_all;

        if (argc < 2) {
                fprintf(stderr, "Usage: %s filename\n",
                                                basename(argv[0]));
                exit(EXIT_FAILURE);
        }

        /* Відкриває файл argv[1] для читання. */    
        fd = open();
        if (fd < 0) {
                perror("open()");
                exit(EXIT_FAILURE);
        }

        count_all = 0;
        while (1) {
                char buf[BUFSIZE];
                /* Кількість щойно прочитаних із файлу байтів */
                ssize_t count;

                /* Читає з файлу fd у буфер buf BUFSIZE байтів. */
                count = read();
                if (count < 0) {
                        perror("read()");
                        exit(EXIT_FAILURE);
                } else if (count == 0)
                        break;

                /* Виводить щойно прочитану порцію даних. */
                if (print_buffer(count_all, buf, count) != 0)
                        exit(EXIT_FAILURE);

                count_all += BUFSIZE;
        }

        exit(EXIT_SUCCESS);
}

/* Виводить дамп буфера buf у шістнадцятковому й текстовому форматі.
   count_all - кількість попередньо оброблених байтів
   count - кількість байтів у буфері 
   Повертає 0 у випадку успіху, та інше значення у випадку помилки. */
int print_buffer(ssize_t count_all, char *buf, ssize_t count) 
{
        char hexstr[9];
        int i;

        /* Перетворює значення count_all в шістнадцятковий формат
           і зберігає результат в буфері hexstr. */
        sprintf(hexstr, "%.8x", count_all);
        /* Виводить 8 символів із буфера hexstr,
           після чого виводить 2 пробіли. */
	if (write() < 0 || write() < 0) {
                perror("write()");
                return 1;
	}
        for (i = 0; i < count; i++) {
                /* Перетворює в шістнадцятковий формат i-й символ
                   буфера buf і зберігає результат в буфері hexstr. */
                sprintf(hexstr, "%.2x", (unsigned int) buf[i]);
                /* Виводить 2 символи з буфера hexstr,
                   після чого виводить 1 пробіл. */
                if (write() < 0 || write() < 0) {
                        perror("write()");
                        return 1;
                }
        }
        while (i < BUFSIZE) {
                /* Виводить 3 пробіли. */
                if (write() < 0) {
                        perror("write()");
                        return 1;
                }
                i++;
        }
        /* Виводить пробіл і символ |. */
        if (write() < 0) {
                perror("write()");
                return 1;
        }
        /* Замінює крапками невидимі символи буфера buf. */
        supress_nonprint(buf, count);
        /* Виводить count символів із буфера buf. */
        if (write() < 0) {
                perror("write()");
                return 1;
        }
        for (i = count; i < BUFSIZE; i++) {
                /* Виводить 1 пробіл. */
                if (write() < 0) {
                        perror("write()");
                        return 1;
                }
        }
        /* Виводить символи | і \n. */
        if (write() < 0) {
                perror("write()");
                return 1;
        }
        return 0;
}

/* Замінює крапками невидимі символи буфера buf.
   count - кількість символів у буфері buf */
void supress_nonprint(char *buf, ssize_t count) {
        int i;

        for (i = 0; i < count; i++)
                if (!isprint(buf[i]))
                        buf[i] = '.';
}
